/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.class_5352;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<class_3264, ResourceManagerHelperImpl> registryMap = new HashMap<class_3264, ResourceManagerHelperImpl>();
    private static final Set<class_3545<String, ModNioResourcePack>> builtinResourcePacks = new HashSet<class_3545<String, ModNioResourcePack>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManagerHelperImpl.class);
    private final Set<class_2960> addedListenerIds = new HashSet<class_2960>();
    private final Set<IdentifiableResourceReloadListener> addedListeners = new LinkedHashSet<IdentifiableResourceReloadListener>();

    public static ResourceManagerHelperImpl get(class_3264 type) {
        return registryMap.computeIfAbsent(type, t -> new ResourceManagerHelperImpl());
    }

    public static boolean registerBuiltinResourcePack(class_2960 id, String subPath, ModContainer container, String displayName, ResourcePackActivationType activationType) {
        String separator = container.getRootPath().getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        String name = displayName;
        ModNioResourcePack resourcePack = ModNioResourcePack.create(name, container, subPath, class_3264.field_14188, activationType);
        ModNioResourcePack dataPack = ModNioResourcePack.create(name, container, subPath, class_3264.field_14190, activationType);
        if (resourcePack == null && dataPack == null) {
            return false;
        }
        if (resourcePack != null) {
            builtinResourcePacks.add((class_3545<String, ModNioResourcePack>)new class_3545((Object)name, (Object)resourcePack));
        }
        if (dataPack != null) {
            builtinResourcePacks.add((class_3545<String, ModNioResourcePack>)new class_3545((Object)name, (Object)dataPack));
        }
        return true;
    }

    public static boolean registerBuiltinResourcePack(class_2960 id, String subPath, ModContainer container, ResourcePackActivationType activationType) {
        return ResourceManagerHelperImpl.registerBuiltinResourcePack(id, subPath, container, id.method_12836() + "/" + id.method_12832(), activationType);
    }

    public static void registerBuiltinResourcePacks(class_3264 resourceType, Consumer<class_3288> consumer, class_3288.class_5351 factory) {
        for (class_3545<String, ModNioResourcePack> entry : builtinResourcePacks) {
            ModNioResourcePack pack = (ModNioResourcePack)entry.method_15441();
            if (pack.method_14406(resourceType).isEmpty()) continue;
            class_3288 profile = class_3288.method_14456((String)((String)entry.method_15442()), (pack.getActivationType() == ResourcePackActivationType.ALWAYS_ENABLED ? 1 : 0) != 0, () -> entry.method_15441(), (class_3288.class_5351)factory, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)new BuiltinModResourcePackSource(pack.getFabricModMetadata().getId()));
            if (profile == null) continue;
            consumer.accept(profile);
        }
    }

    public static List<class_3302> sort(class_3264 type, List<class_3302> listeners) {
        if (type == null) {
            return listeners;
        }
        ResourceManagerHelperImpl instance = ResourceManagerHelperImpl.get(type);
        if (instance != null) {
            ArrayList<class_3302> mutable = new ArrayList<class_3302>(listeners);
            instance.sort(mutable);
            return Collections.unmodifiableList(mutable);
        }
        return listeners;
    }

    protected void sort(List<class_3302> listeners) {
        listeners.removeAll(this.addedListeners);
        ArrayList listenersToAdd = Lists.newArrayList(this.addedListeners);
        HashSet<class_2960> resolvedIds = new HashSet<class_2960>();
        for (class_3302 listener : listeners) {
            if (!(listener instanceof IdentifiableResourceReloadListener)) continue;
            resolvedIds.add(((IdentifiableResourceReloadListener)listener).getFabricId());
        }
        int lastSize = -1;
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                IdentifiableResourceReloadListener listener = (IdentifiableResourceReloadListener)it.next();
                if (!resolvedIds.containsAll(listener.getFabricDependencies())) continue;
                resolvedIds.add(listener.getFabricId());
                listeners.add(listener);
                it.remove();
            }
        }
        for (IdentifiableResourceReloadListener listener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + listener.getFabricId() + "!");
        }
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        if (!this.addedListenerIds.add(listener.getFabricId())) {
            LOGGER.warn("Tried to register resource reload listener " + listener.getFabricId() + " twice!");
            return;
        }
        if (!this.addedListeners.add(listener)) {
            throw new RuntimeException("Listener with previously unknown ID " + listener.getFabricId() + " already in listener set!");
        }
    }
}

